﻿namespace Hims.Api.Profiles
{
    using AutoMapper;
    using Models.Appointment;
    using Models.Patient;
    using Models.Practice;
    using Models.Provider;
    using Shared.EntityModels;

    /// <inheritdoc />
    public class MappingProfile : Profile
    {
        /// <inheritdoc />
        public MappingProfile()
        {
            // Practice
            this.CreateMap<PracticeRegistrationRequest, PracticeModel>();
            this.CreateMap<ModifyPracticeRequest, PracticeModel>();

            // Provider
            this.CreateMap<ModifyProviderRequest, ProviderModel>();
            this.CreateMap<ModifyProviderLocationRequest, ProviderLocationModel>();

            // Patient
            this.CreateMap<ModifyPatientRequest, PatientModel>();

            // Appointment
            this.CreateMap<BookAppointmentRequest, AppointmentLogModel>();
            this.CreateMap<BookAppointmentRequest, AppointmentModel>();
        }
    }
}
